/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.core.v2_1.graphics;

import com.roguewave.chart.core.v2_1.graphics.Canvas3D;
import com.roguewave.chart.core.v2_1.graphics.Drawable;
import com.roguewave.chart.core.v2_1.graphics.Point3D;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public class BufferedCanvas3D
extends Canvas3D {
    transient Image buffer_;
    transient Graphics imageGraphics_;
    transient boolean modified_ = true;
    Dimension bufferSize_;
    boolean bufferDisabled_ = false;

    protected void init(Graphics graphics) {
        this.bufferSize_ = this.getSize();
        this.buffer_ = this.createImage(this.bufferSize_.width, this.bufferSize_.height);
        if (this.buffer_ == null) {
            System.err.println("BufferedCanvas3D.init: buffer == null");
            return;
        }
        this.imageGraphics_ = this.buffer_.getGraphics();
        this.imageGraphics_.setFont(graphics.getFont());
        this.modified_ = true;
    }

    public void update(Graphics graphics) {
        if (this.bufferDisabled_) {
            graphics.setColor(this.getForeground());
            this.paintFrame(graphics);
            return;
        }
        Dimension dimension = this.getSize();
        if (this.buffer_ == null || dimension.width != this.bufferSize_.width || dimension.height != this.bufferSize_.height) {
            this.init(graphics);
            if (this.buffer_ == null) {
                graphics.clearRect(0, 0, this.bufferSize_.width, this.bufferSize_.height);
                graphics.setColor(this.getForeground());
                this.paintFrame(graphics);
                return;
            }
        }
        if (this.modified_) {
            this.imageGraphics_.clearRect(0, 0, this.bufferSize_.width, this.bufferSize_.height);
            System.currentTimeMillis();
            this.imageGraphics_.setColor(this.getForeground());
            this.paintFrame(this.imageGraphics_);
            System.currentTimeMillis();
            this.modified_ = false;
        }
        graphics.drawImage(this.buffer_, 0, 0, null);
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void disableBuffering() {
        this.bufferDisabled_ = true;
    }

    public void disableBuffering(boolean bl) {
        this.bufferDisabled_ = bl;
    }

    public void enableBuffering() {
        this.bufferDisabled_ = false;
    }

    public void setDrawableModified() {
        this.modified_ = true;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.modified_ = true;
    }

    public void setPerspective() {
        super.setPerspective();
        this.modified_ = true;
    }

    public void setPerspective(double d) {
        super.setPerspective(d);
        this.modified_ = true;
    }

    public void setShear() {
        super.setShear();
        this.modified_ = true;
    }

    public void setShear(double d, double d2) {
        super.setShear(d, d2);
        this.modified_ = true;
    }

    public void setView(double d, double d2, double d3) {
        super.setView(d, d2, d3);
        this.modified_ = true;
    }

    public void setRotation(double d) {
        super.setRotation(d);
        this.modified_ = true;
    }

    public void setTilt(double d) {
        super.setTilt(d);
        this.modified_ = true;
    }

    public void setViewDistance(double d) {
        super.setViewDistance(d);
        this.modified_ = true;
    }

    public synchronized void addDrawable(Drawable drawable) {
        super.addDrawable(drawable);
        this.modified_ = true;
    }

    public synchronized void clear() {
        super.clear();
        this.modified_ = true;
    }

    public void set2DXScale(double d) {
        super.set2DXScale(d);
        this.modified_ = true;
    }

    public void set2DYScale(double d) {
        super.set2DYScale(d);
        this.modified_ = true;
    }

    public void set3DBorder(int n) {
        super.set3DBorder(n);
        this.modified_ = true;
    }

    public void pan(int n, int n2) {
        super.pan(n, n2);
        this.modified_ = true;
    }

    public void setAspectPreservation(boolean bl) {
        super.setAspectPreservation(bl);
        this.modified_ = true;
    }

    public void setBoundingWindow(Point3D[] point3DArray, int n, int n2, int n3, int n4) {
        super.setBoundingWindow(point3DArray, n, n2, n3, n4);
        this.modified_ = true;
    }
}

